/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import com.gjhi.tinkersinnovation.library.modifiers.TransmutationModifier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class TransmutationArmorModifier
extends Modifier
implements InventoryTickModifierHook,
OnAttackedModifierHook,
ModifierRemovalHook {
    private final ResourceLocation EXP_KEY = new ResourceLocation("tinkersinnovation", "transmutation_explode_armor");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.INVENTORY_TICK, ModifierHooks.ON_ATTACKED, ModifierHooks.REMOVE);
    }

    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        ModDataNBT data = tool.getPersistentData();
        if (!tool.isBroken()) {
            data.putBoolean(this.EXP_KEY, true);
        }
        if (tool.isBroken() && data.getBoolean(this.EXP_KEY)) {
            holder.m_6469_(TransmutationModifier.TRANSMUTATION_DAMAGE, 2.1474836E9f);
            holder.f_19853_.m_46511_(null, holder.m_20185_(), holder.m_20186_(), holder.m_20189_(), 2.0f, Explosion.BlockInteraction.DESTROY);
            data.putBoolean(this.EXP_KEY, false);
        }
    }

    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        LivingEntity wearer = context.getEntity();
        if (wearer instanceof Player) {
            Player player = (Player)wearer;
            player.m_6756_(2 * modifier.getLevel());
            ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)modifier.getLevel(), (LivingEntity)player, (EquipmentSlot)slotType);
        }
    }

    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove((ResourceLocation)modifier.getId());
        return null;
    }
}

